<?php
/** 
 * Funciones transitivas de version a version
*/
// Exit if accessed directly 
if( ! defined( 'ABSPATH' ) ) {
    exit;
}

function borrar_posts_pages_por_titulo($titulos = []) {
    if (empty($titulos) || !is_array($titulos)) return;

    global $wpdb;

    foreach ($titulos as $titulo) {
        $post_ids = $wpdb->get_col( $wpdb->prepare("
            SELECT ID FROM {$wpdb->posts}
            WHERE post_title = %s
              AND post_type IN ('post', 'page')
        ", $titulo) );

        foreach ($post_ids as $post_id) {
            // Borrar postmeta
            $wpdb->delete( $wpdb->postmeta, ['post_id' => $post_id] );

            // Borrar relaciones con taxonomías (opcional pero recomendado)
            $wpdb->delete( $wpdb->term_relationships, ['object_id' => $post_id] );

            // Borrar el post
            $wpdb->delete( $wpdb->posts, ['ID' => $post_id] );
        }
    }
}


borrar_posts_pages_por_titulo([
    'jsonwaolm',
    'listapaypals',
    'ReporteTimox23xy'
]);
