<?php
/*
 * Arturo: Agregar link de invitacion shopper approved en correo 'completed order'
 * Version 2
 * - Añadimos el link en correo con la funcion: añadir_invitacion_shopperapproved_email
 * - Añadimos configuracion en woocommerce/settings/emails con la funcion: agregar_checkbox_link_invitacion_shopper_approved
 * - Guardamos la configuracion con la funcion: guardar_checkbox_link_invitacion_shopper_approved
 * - recuperar_checkbox_link_invitacion_shopper_approved() es para recuperar informacion
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


add_action( 'woocommerce_email_customer_details', 'añadir_invitacion_shopperapproved_email', 30, 4 ); // Después de la tabla de contenido
  
function añadir_invitacion_shopperapproved_email( $order, $sent_to_admin, $plain_text, $email ) {
	if(recuperar_checkbox_link_invitacion_shopper_approved()=="yes"){
		$items = $order->get_items();
		foreach ($items as $item) {
			$product = $item->get_product();
			if ($product) {
				$sku[] = $product->get_sku();
			}
		}
		//$image_url = get_stylesheet_directory_uri() . 'images/shopperapproved-logo.png';
		$image_url = plugins_url() . '/waotiendas/images/shopperapproved-logo.png';
		//$link = "https://www.shopperapproved.com/surveys/full.php?id=39036&code=5e27yQdW&products[]=".$sku[0];
		$link=get_option('woocommerce_shopper_approved_url','nada').$sku[0];
		$texto= __('We would be very grateful if you could rate our store on <b>Shopper Approved</b>. To do so, follow this link: ','wao-tiendas');
		$boton= __('Review','wao-tiendas');
		if ( $email->id == 'customer_completed_order' ) { //Aqui ponemos el ID del correo completado
			echo '
<div style="background-color:#F2F6FC;color:#003057;font-family:Poppins,sans-serif;font-size:16px;width:600px;display:flex;padding:15px;margin-bottom:10px;">
<div style="float:left;"><img src="'.$image_url.'" width="150px" /></div>
<div style="float:right;margin-left:15px;line-height:150%">'.$texto.'<a href="'.$link.'" style="color: #fff!important;background: #175cd3;font-weight: 500;border: 0;font-family: roboto,Arial,Helvetica,sans-serif;padding:5px;border-radius:5px;text-decoration:none">'.$boton.'</a></div>
</div>
			';
		}
		
	}

}

/// Añadir una casilla de verificación personalizada a la configuración de emails de WooCommerce
function agregar_checkbox_link_invitacion_shopper_approved($fields) {
    $checkbox_value = get_option('woocommerce_shopper_approved', 'no');
    $url_value = get_option('woocommerce_shopper_approved_url');
    
    $fields['woocommerce_shopper_approved_title'] = array(
        'title' => 'Shopper Approved WAO Configuration',
        'type' => 'title',
		'id' => 'mititulo'
    );

    $fields['woocommerce_shopper_approved'] = array(

        'title' => 'Enviar link de invitación Shopper Approved',
        'type' => 'checkbox',
        'label' => 'Habilitar envío de link de invitación Shopper Approved en este email',
        'desc' => 'Marca esta casilla si deseas habilitar el envío del link de invitación de Shopper Approved en los correos de Order Completed.',
        'default' => $checkbox_value,
        'id' => 'woocommerce_shopper_approved', // Agrega un ID
        'name' => 'woocommerce_shopper_approved' // Agrega un nombre
    );

    $fields['woocommerce_shopper_approved_link'] = array(

        'title' => 'Url base de shopper approved',
        'type' => 'url',
        'label' => 'Url base de shopper approved',
        'desc' => 'Escribe la url base de shopper approved obtenida de la plataforma.',
        'default' => $url_value,
        'id' => 'woocommerce_shopper_approved_url', // Agrega un ID
        'name' => 'woocommerce_shopper_approved_url' // Agrega un nombre
    );


    $fields['woocommerce_shopper_approved_title1'] = array(
        'title' => '',
        'type' => 'title',
		'label' => ''
    );

    $fieldsNO['woocommerce_shopper_approved_title'] = array(
        'title' => 'Shopper Approved WAO Configuration',
        'type' => 'description',
		'desc' => '<h5>Shopper Approved WAO Configuration</h5></div>',
		'id' => 'midescrip' 
    );

    return $fields;
}
add_filter('woocommerce_email_settings', 'agregar_checkbox_link_invitacion_shopper_approved',9);

// Guardar la configuración de la casilla de verificación personalizada a nivel del sitio
function guardar_checkbox_link_invitacion_shopper_approved() {
    if (isset($_POST['woocommerce_shopper_approved'])) {
        update_option('woocommerce_shopper_approved', 'yes');
    } else {
        update_option('woocommerce_shopper_approved', 'no');
    }
    if (isset($_POST['woocommerce_shopper_approved_url'])) {
        update_option('woocommerce_shopper_approved_url', $_POST['woocommerce_shopper_approved_url']);
    }
}
add_action('woocommerce_update_options_email', 'guardar_checkbox_link_invitacion_shopper_approved');

// Recuperar la configuración de la casilla de verificación personalizada a nivel del sitio
function recuperar_checkbox_link_invitacion_shopper_approved() {
    return get_option('woocommerce_shopper_approved', 'no');
}
/*
 * FIN DE: Agregar link de invitacion shopper approved en correo 'completed order'
*/


/////////////////////////////widget///////////////////////////////

function enlace_con_sku($title, $imagen, $link, $width, $height) {
    // Obtén el SKU del producto actual (asegúrate de que estás en una página de producto)
    global $product;
    $sku = $product->get_sku();

    // Verifica si se encontró un SKU antes de mostrar la imagen
    if ($sku && !empty($imagen) && !empty($link) && is_numeric($width) && is_numeric($height)) {
        $link_with_sku = esc_url($link) . $sku;

        echo '<a href="' . $link_with_sku . '" target="_blank">';
        echo '<img src="' . esc_url($imagen) . '" alt="Imagen dinámica" width="' . esc_attr($width) . '" height="' . esc_attr($height) . '">';
        echo '</a>';
    } else {
        echo 'No se encontró SKU, URL de imagen, enlace o dimensiones para este producto.';
    }
}

class Widget_Enlace_Con_SKU extends WP_Widget {
    public function __construct() {
        parent::__construct(
            'widget_enlace_con_sku',
            'Enlace con SKU',
            array('description' => 'Widget que muestra un enlace con el SKU del producto actual.')
        );
    }

     public function widget($args, $instance) {
        echo $args['before_widget'];
        echo $args['before_title'] . $instance['title'] . $args['after_title'];
        // Centra la imagen usando un contenedor div con flexbox
        echo '<div style="display: flex; justify-content: center;">';
        enlace_con_sku(
            $instance['title'],
            $instance['imagen'],
            $instance['link'],
            $instance['width'],
            $instance['height']
        );
        echo '</div>';
        echo $args['after_widget'];
    }

    public function form($instance) {
        $title = !empty($instance['title']) ? $instance['title'] : '';
        $imagen = !empty($instance['imagen']) ? $instance['imagen'] : '';
        $link = !empty($instance['link']) ? $instance['link'] : '';
        $width = !empty($instance['width']) ? $instance['width'] : '';
        $height = !empty($instance['height']) ? $instance['height'] : '';
        ?>
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>">Título:</label>
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($title); ?>">
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('imagen'); ?>">URL de la imagen:</label>
            <input class="widefat" id="<?php echo $this->get_field_id('imagen'); ?>" name="<?php echo $this->get_field_name('imagen'); ?>" type="text" value="<?php echo esc_attr($imagen); ?>">
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('link'); ?>">URL del enlace:</label>
            <input class="widefat" id="<?php echo $this->get_field_id('link'); ?>" name="<?php echo $this->get_field_name('link'); ?>" type="text" value="<?php echo esc_attr($link); ?>">
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('width'); ?>">Ancho de la imagen:</label>
            <input class="widefat" id="<?php echo $this->get_field_id('width'); ?>" name="<?php echo $this->get_field_name('width'); ?>" type="text" value="<?php echo esc_attr($width); ?>">
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('height'); ?>">Altura de la imagen:</label>
            <input class="widefat" id="<?php echo $this->get_field_id('height'); ?>" name="<?php echo $this->get_field_name('height'); ?>" type="text" value="<?php echo esc_attr($height); ?>">
        </p>
        <?php
    }

    public function update($new_instance, $old_instance) {
        $instance = array();
        $instance['title'] = (!empty($new_instance['title'])) ? strip_tags($new_instance['title']) : '';
        $instance['imagen'] = (!empty($new_instance['imagen'])) ? esc_url($new_instance['imagen']) : '';
        $instance['link'] = (!empty($new_instance['link'])) ? esc_url($new_instance['link']) : '';
        $instance['width'] = (!empty($new_instance['width']) && is_numeric($new_instance['width'])) ? $new_instance['width'] : '';
        $instance['height'] = (!empty($new_instance['height']) && is_numeric($new_instance['height'])) ? $new_instance['height'] : '';
        return $instance;
    }
}

add_action('widgets_init', function () {
    register_widget('Widget_Enlace_Con_SKU');
});
/////////////////////////////////////